{********************************************
; File: Memory.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT MEMORY;
INTERFACE
USES TYPES,MISCTOOL;
CONST

{ Error Codes }
memErr = $0201;  { unable to allocate block }
emptyErr = $0202;  { illegal operation, empty handle }
notEmptyErr = $0203;  { an empty handle was expected for this operation }
lockErr = $0204;  { illegal operation on a locked block }
purgeErr = $0205;  { attempt to purge an unpurgable block }
handleErr = $0206;  { an invalid handle was given }
idErr = $0207;  { an invalid owner ID was given }
attrErr = $0208;  { operation illegal on block with given attributes }

{ Handle Attribute Bits }
attrNoPurge = $0000;  { Not purgeable }
attrBank = $0001;  { fixed bank }
attrAddr = $0002;  { fixed address }
attrPage = $0004;  { page aligned }
attrNoSpec = $0008;  { may not use special memory }
attrNoCross = $0010;  { may not cross banks }
attrPurge1 = $0100;  { Purge level 1 }
attrPurge2 = $0200;  { Purge level 2 }
attrPurge3 = $0300;  { Purge level 3 }
attrPurge = $0300;  { test or set both purge bits }
attrHandle = $1000;  { block of master pointers }
attrSystem = $2000;  { system handle }
attrFixed = $4000;  { not movable }
attrLocked = $8000;  { locked }
PROCEDURE AddToOOMQueue ( headerPtr:Ptr)  ;
PROCEDURE BlockMove ( srcPtr:Ptr; dstPtr:Ptr; count:Longint)  ;
PROCEDURE CheckHandle ( theHandle:Handle)  ;
PROCEDURE CompactMem   ;
PROCEDURE DisposeAll ( userID:Integer)  ;
PROCEDURE DisposeHandle ( theHandle:Handle)  ;
FUNCTION FindHandle ( locationPtr:Ptr) : Handle ;
FUNCTION FreeMem  : Longint ;
FUNCTION GetHandleSize ( theHandle:Handle) : Longint ;
PROCEDURE HandToHand ( sourceHandle:Handle; destHandle:Handle; count:Longint)  ;
PROCEDURE HandToPtr ( sourceHandle:Handle; destPtr:Ptr; count:Longint)  ;
PROCEDURE HLock ( theHandle:Handle)  ;
PROCEDURE HLockAll ( userID:Integer)  ;
PROCEDURE HUnlock ( theHandle:Handle)  ;
PROCEDURE HUnlockAll ( userID:Integer)  ;
FUNCTION MaxBlock  : Longint ;
PROCEDURE MMBootInit   ;
PROCEDURE MMReset   ;
PROCEDURE MMShutDown ( userID:Integer)  ;
FUNCTION MMStartUp  : Integer ;
FUNCTION MMStatus  : Boolean ;
FUNCTION MMVersion  : Integer ;
FUNCTION NewHandle ( blockSize:Longint; userID:Integer; attributes:Integer; locationPtr:Ptr) : Handle ;
PROCEDURE PtrToHand ( sourcePtr:Ptr; destHandle:Handle; count:Longint)  ;
PROCEDURE PurgeAll ( userID:Integer)  ;
PROCEDURE PurgeHandle ( theHandle:Handle)  ;
FUNCTION RealFreeMem  : Longint ;
PROCEDURE ReAllocHandle ( blockSize:Longint; userID:Integer; attributes:Integer; locationPtr:Ptr; theHandle:Handle)  ;
PROCEDURE RemoveFromOOMQueue ( headerPtr:Ptr)  ;
PROCEDURE RestoreHandle ( theHandle:Handle)  ;
PROCEDURE SetHandleSize ( newSize:Longint; theHandle:Handle)  ;
PROCEDURE SetPurge ( newPurgeLevel:Integer; theHandle:Handle)  ;
PROCEDURE SetPurgeAll ( newPurgeLevel:Integer; userID:Integer)  ;
FUNCTION TotalMem  : Longint ;
IMPLEMENTATION
END.
